$!DIGEST.COM
$!
$! This command procedure, when used in cooperation with PMDF's DELIVER
$! facility, will automatically digestify incoming messages to a mailing
$! list MAILLIST.  When the digest is over 24 hours old, or when the size of 
$! the digest gets larger than some given size, the digest will be sent to the
$! recipients of MAILLIST-DIGEST.  The digest will then be appended
$! to an archive of the mailing list.
$!
$! You an vary the behavior of any one list by having a command procedure
$! PARAMTERS.COM which changes the values for 
$! 	maximum_archive_size
$!	maximum_archive_age
$!	maximum_issue_per_volume
$!	allow_force
$!
$! jms/950725
$!
$! Joel M Snyder, 1404 East Lind Road, Tucson, AZ, 85719
$! Phone: +1 520 324 0494 x101 (v) +1 520 324 0495 (FAX)  
$! jms@Opus1.COM    http://www.opus1.com/jms    Opus One
$!
$! Installation Instructions
$!
$! - create an account DIGEST which has the DIGEST.COM in it's login
$!   directory and sufficient ACL identifiers to write to the 
$!   PMDF_MAILSERV_MAIL_DIR:[blah] directories.  Typically, this means
$!   $ set file/acl=(id=digest,acc=R+W+E+D+C) -
$!		pmdf_mailserv_files_dir:[000000]<listname>.dir
$!   $ set file/acl=(id=digest,opt=default,acc=R+W+E+D+C) -
$!		pmdf_mailserv_files_dir:[000000]<listname>.dir
$! - add the following MAIL.DELIVERY to [DIGEST]
$!   
$!	* * * A 3 "ENVELOPE-TO"
$!	* * * A S
$!	* * * a E @DIGEST.COM
$!	* * * a q
$!
$! From there on out, it's self-configuring & self-operating.
$!
$! Operation/Configuration Instructions
$!
$! Any list to be digestified must have the following:
$! 1- a directory in PMDF_MAILSERV_FILES_DIR:[<listname>] where
$!    digests go (and with APPROPRIATE ACLS!!!)
$! 2- the mailing list <listname>-Digest is where the digest will
$!    be sent.  This is usually set up something like this:
$!
$!	testlist:       <pmdf_root:[table.aliases]testlist.dis, \
$!	                testlist@Opus1.COM, \
$!	                testlist@Opus1.COM, \
$!	                testlist-Error@Opus1.COM, *, \
$!	                This is just a test list
$!	testlist-Error:         jms@Opus1.COM
$!	testlist-digest:<pmdf_root:[table.aliases]testlist-digest.dis, \
$!	                testlist@Opus1.COM, \
$!	                testlist@Opus1.COM, \
$!	                testlist-digest-owner@Opus1.COM, *, \
$!	                This is the test list digest
$!	testlist-digest-owner:  jms@opus1.com
$!
$! 3- the user "digest+<listname>" added to the list.  Make sure that
$!    the capitalization you use for "listname" is what you want to be
$!    used to name the list. 
$! 4- the file PMDF_MAILSERV_FILES_DIR:[<listname>]CONTENTS.NOTE, if
$!    present, will be put between the table of contents and the actual
$!    digest.  If not present, no problem.
$! 5- the file PMDF_MAILSERV_FILES_DIR:[<listname>]FINAL.NOTE, if
$!    present, will be put at the END of the digest.  If not present,
$!    ignored.
$! 6- the file PMDF_MAILSERV_FILES_DIR:[<listname>]PARAMETERS.COM, if
$!    present, will be executed to change values for the list.  If
$!    not present, the defaults will be used (see immediately below).
$! 
$!
$!+++
$! Here are some parameters which you might have to change, based
$! on what your site does.  These can also be changed on a per-list
$! basis by creating a file "parameters.com" in the list directory
$! which redefines these.
$!---
$ set ver
$ PMDF_MAIL_TRANSPORT == "IN%"
$ MAXIMUM_ARCHIVE_SIZE == 50		! blocks allocated, 1 blk=512 byt
$ MAXIMUM_ARCHIVE_AGE == 1		! normal archive age, 1 day
$ MAXIMUM_ISSUE_PER_VOLUME == 350	! issues per volume
$ ALLOW_FORCE == "FALSE"		! allow a FORCE to send a digest
$!
$!+++
$! You can force a mailing list digest to go out by calling this
$! command procedure with the P1 argument "FORCE" and the P2 argument
$! the listname, e.g.: $ @digest FORCE TESTLIST
$! HOWEVER, the mailing list can only be forced if ALLOW_FORCE is set
$! to true in the PARAMETERS.COM file.  If you want to override the
$! setting of allow_force (presumably for debugging), then make P1
$! be "FORCEX" instead of "FORCE".
$!---
$ if ("''p1'" .eqs. "FORCEX")
$ then
$	p1 = "FORCE"
$	allow_force == "TRUE"
$ endif
$ if ("''p1'" .eqs. "FORCE")
$ then
$	if ("''p2'" .eqs. "") 
$	then
$	    request/to=network "DIGEST-F-NOFORCE, No list name given"
$	    write sys$output "DIGEST-F-NOFORCE, No list name given to force"
$	    exit
$	endif
$	listname = ''P2'
$	goto SETUP_FILES  ! skip over the C3 stuff
$ endif
$!
$!+++
$! Figure out what mailing list we are dealing with.  The Envelope
$! TO address should be "digest+<list-name>@domain", so we get everything
$! after the first plus sign and then copy over to the first @ sign.
$!
$! NOTE that we chose C3 (column 3) to use for our To field, so we
$! have to use that one.
$!
$!---
$ length_to = f$length(C3)
$ if (length_to .eq. 0) 
$ then
$	! this is an illegally addressed message and should
$	! be ignored.
$	exit
$ endif
$ plus_to = f$locate("+",C3)
$ ! It is possible for the @ to be elided (i.e., the envelope
$ ! is to "digest+listname" instead of "digest+listname@foo.bar,"
$ ! in which case we should handle this case politely.  Fortunately,
$ ! it all works out just fine the way it is.
$ at_to = f$locate("@",C3)
$ !
$ if (  (plus_to .eq. length_to) .or. -
	(plus_to .ge. at_to)   )
$ then
$	! this needs to have a plus in it, and doesn't.  Alert the
$	! authorities and exit.  Alternatively: needs to have an
$	! @ in it, or needs to have some space between the plus and
$	! the at.
$	sho sym C3
$	sho sym plus_to
$	sho sym at_to
$	request/to=network "DIGEST-F-NOPLUSAT, Illegal message in digest"
$	exit
$ endif
$ listname = f$extract(plus_to+1, (at_to - plus_to - 1), C3)
$!
$!+++
$! HOOK: Here is where you'd do some authentication to see if this
$! is a place where this list should be digestified.  As it is, we
$! define our system so that ANY list can be digestified.  We define
$! a list as "any list which has a directory in PMDF_MAILSERV_FILES_DIR"
$!---
$setup_files:
$ SHO SYM LISTNAME		! debugging information
$ if (f$search("PMDF_MAILSERV_FILES_DIR:[000000]''listname'.DIR") .eqs. "") 
$ then
$	! this list is not able to be digested.
$	request/to=network "DIGEST-F-INDIGESTABLE, No directory for ''listname'"
$	exit
$ endif
$!
$!+++
$! We use the CURRENT_CONTENTS and CURRENT_TEXT files so often that
$! it pays to figure out what those names are here and just use
$! the symbols from now on.  We also define:
$!
$! current_contents - the file where the current table of contents is
$! current_text - the file where all of the current text is
$! issue_filename - the file where we keep the issue number stored
$! volume_filename - the file where we keep the volume number stored
$! contents_note - a note which is sent out after the contents and before
$! 	the text
$! final_note - a note which is sent out at the end of each archive
$! (note that contents_note & final_note are optional and will not cause
$! errors if they're not present)
$! 
$!---
$ CURRENT_CONTENTS = "PMDF_MAILSERV_FILES_DIR:[''listname']CURRENT.CONTENTS"
$ CURRENT_TEXT     = "PMDF_MAILSERV_FILES_DIR:[''listname']CURRENT.TEXT"
$ ISSUE_FILENAME   = "PMDF_MAILSERV_FILES_DIR:[''listname']ISSUE.NUMBER"
$ VOLUME_FILENAME   = "PMDF_MAILSERV_FILES_DIR:[''listname']VOLUME.NUMBER"
$ CONTENTS_NOTE     = "PMDF_MAILSERV_FILES_DIR:[''listname']CONTENTS.NOTE"
$ FINAL_NOTE        = "PMDF_MAILSERV_FILES_DIR:[''listname']FINAL.NOTE"
$ PARAMETERS_FILE   = "PMDF_MAILSERV_FILES_DIR:[''listname']PARAMETERS.COM"
$ LOG_FILE          = "SYS$LOGIN:DIGEST.LOG"
$!
$!+++
$! Give the list other the chance to change any parameters about the
$! list. Typically, these would be the maximum archive size and the
$! length of time to wait.
$!---
$ if (f$search(PARAMETERS_FILE) .nes. "") then $ @'PARAMETERS_FILE'
$ sho symbol MAXIMUM_ARCHIVE_SIZE 
$ sho symbol MAXIMUM_ARCHIVE_AGE 
$ sho symbol MAXIMUM_ISSUE_PER_VOLUME 
$ sho symbol ALLOW_FORCE
$!
$!+++
$! Log the entry.
$!---
$ if (f$search(LOG_FILE) .eqs. "") then $ copy NL: 'LOG_FILE'
$ open/append/error=cannot_open_contents log 'LOG_FILE'
$ write log "''f$cvt(,""ABSOLUTE"")' ''qfrom' ''listname'"
$!
$!+++
$! If this is a "forced" send, then don't bother to try and append;
$! just check to see if the contents are valid.
$!---
$ if ( "''P1'" .eqs. "FORCE")
$ then
$	if (.NOT. ALLOW_FORCE) 
$	then
$	    write sys$output "List ''listname' may not be forced."
$	    close log
$	    exit
$	endif
$ 	if (f$search(CURRENT_CONTENTS) .eqs. "") 
$ 	then
$	    write sys$output "No digest to send for ''listname'."
$	    close log
$	    exit
$	endif
$	goto SEND_ARCHIVE
$ endif
$! 
$!
$!+++
$! The archives are kept in PMDF_MAILSERV_FILES_DIR:[<listname>].  
$! See if there is an archive file already by looking for a contents
$! file.  If there isn't, then 
$!	- create a new contents file 
$!	  (we have to do this strangely to get the file attributes right)
$!	- open the contents file
$!	- create a new text file
$!	- figure out the volume & issue numbers
$!	- increment the issue number (and if necessary the volume number)
$!	- write the contents header
$! else 
$!	- open the contents file
$!
$! Add this message to the end of the current archive, and 
$! add the subject line to the end of the current subject contents
$! list.
$!---
$ if (f$search(CURRENT_CONTENTS) .eqs. "") 
$ then
$	copy NL: 'CURRENT_CONTENTS'
$	copy NL: 'CURRENT_TEXT'
$ 	open contents 'CURRENT_CONTENTS' /APPEND/ERROR=cannot_open_contents
$	gosub determine_current_vi_number
$	gosub increment_issue_number
$	gosub determine_date_time
$	write /ERROR=cannot_write_contents contents -
		"''listname'-Digest    ''today'  "+-
		"Volume ''volume_number' : Number ''issue_number'"
$	write /ERROR=cannot_write_contents contents ""
$	write /ERROR=cannot_write_contents contents "In this issue:"
$	write /ERROR=cannot_write_contents contents ""
$	write log "Created new version of contents file for ''listname'"
$!
$ else
$ 	open contents 'CURRENT_CONTENTS' /APPEND/ERROR=cannot_open_contents
$ endif
$!
$ write /ERROR=cannot_write_contents contents "	''qsubject'"
$ close contents /error=cannot_close_contents
$!
$!+++
$! Add the message to the text part of the archive
$!---
$ open text 'CURRENT_TEXT' /APPEND/ERROR=cannot_open_text
$ write /ERROR=cannot_write_text text ""
$ write /ERROR=cannot_write_text text "-------------------------------------"
$ write /ERROR=cannot_write_text text ""
$ gosub figure_out_header_lines
$ write /ERROR=cannot_write_text text "Date: ''header_date'"
$ write /ERROR=cannot_write_text text "From: ''header_from'"
$ write /ERROR=cannot_write_text text "Subject: ''header_subject'"
$ write /ERROR=cannot_write_text text ""
$ close text /ERROR=cannot_close_text
$ append 'message_file' 'CURRENT_TEXT'
$!
$!+++
$! Now, figure out if we have to send this archive off to the 
$! list and archive it.  Basically, we look to see if the contents
$! was created more than 24 hours ago.  If so, then it is time to
$! send it.  
$! One other case: if the size of the file is too large, then we
$! send it as well.
$!---
$ !set verify
$send_archive:
$ if (-
      (f$cvtime(f$file_attributes(CURRENT_CONTENTS,"CDT")) -
	.lts. f$cvtime("-''MAXIMUM_ARCHIVE_AGE'- ") )-
	.OR. -
      (f$file_attributes(CURRENT_TEXT,"ALQ") .gt. MAXIMUM_ARCHIVE_SIZE) -
	.OR. -
      ("''P1'" .eqs. "FORCE") -
     )
$ then
$!+++
$! Figure out the current volume & issue number.  Put together the
$! archive into the archivefile name:
$!
$! 1) contents
$! 2) contents_note (optional)
$! 3) text
$! 4) text_note (optional)
$!
$! rename it all, and then send it out.
$!---
$	gosub determine_current_vi_number
$	archivefile = F$FAO("!ASV!3ZLN!3ZL",-
		"PMDF_MAILSERV_FILES_DIR:[''listname']DIGEST.",-
		f$integer(volume_number), f$integer(issue_number))
$	rename 'CURRENT_CONTENTS' 'archivefile'
$	if (f$search(CONTENTS_NOTE) .nes. "") then -
		$ append 'CONTENTS_NOTE' 'archivefile'
$	append 'CURRENT_TEXT' 'archivefile'
$	if (f$search(FINAL_NOTE) .nes. "") then -
		$ append 'FINAL_NOTE' 'archivefile'
$	delete 'CURRENT_TEXT';
$!	/FROM="''listname'-Digest-Owner" -
$!	/ERRORS_TO="''listname'-Digest-Owner" -
$!	/RETURN_ADDRESS="''listname'" -
$	PMDF SEND 'archivefile' "''listname'-Digest" -
	/EXTRA=("X-Digester-Version: v1.1/jms/960821") -
	/SUBJECT="''listname' Digest V''volume_number' #''issue_number'"-
	/PRIORITY="bulk"
$	write log "Sent digest V''volume_number' N''issue_number' for ''listname'"
$ endif
$ close log
$ exit


$figure_out_header_lines:
$!+++
$! Get the "date," "from," and "subject" lines from the message header into 
$! the variables called header_date, header_from, and header_subject.
$!---
$ open header_file 'message_header' /READ/ERROR=done_with_header
$!
$ gosub determine_date_time
$ header_date = "Date: ''today'"
$ header_from = qfrom - PMDF_MAIL_TRANSPORT
$ header_subject = qsubject
$!
$ figure_out_header_loop:
$     read header_file header_line /END=done_with_header -
		/ERROR=error_in_header
$     keyword = f$edit("''f$extract(0,5,header_line)'","LOWERCASE")
$     if ("''keyword'" .eqs. "date:") then -
	$ header_date = header_line - "Date: "
$     goto figure_out_header_loop

$done_with_header:
$ !sho sym header_date	
$ !sho sym header_from
$ !sho sym header_subject
$ return



$determine_current_vi_number:
$!+++
$! Open the volume & issue number files to figure out
$! the current volume & issue number into the symbols
$! volume_number and issue_number
$!---
$!
$ volume_number = 1
$ issue_number = 1
$!
$ open volume   'VOLUME_FILENAME' /READ/ERROR=init_new_list
$ read volume volume_number /ERROR=init_new_list
$ close volume /ERROR=init_new_list
$!
$ open issue     'ISSUE_FILENAME' /READ/ERROR=init_new_list
$ read issue issue_number /ERROR=init_new_list
$ close issue /ERROR=init_new_list
$!
$ !sho sym volume_number
$ !sho sym issue_number
$ return

$init_new_list:
$!+++
$! This must be a new list.  Create volume 1, issue 1.  Because
$! we're going to immediately increment this, we fake it out by
$! setting the issue number to zero.  This lets the increment make
$! it one.
$!---
$ gosub set_volume_number_to_one
$ gosub set_issue_number_to_one
$ issue_number = 0
$ return



$increment_issue_number:
$!+++
$! Add one to the issue number.  If we exceed the maximum number
$! of issues per volume, then increment the volume number as well
$! and re-set the issue number.
$!---
$ issue_number = issue_number + 1
$ if (issue_number .gt. MAXIMUM_ISSUE_PER_VOLUME) 
$ then 
$ 	gosub increment_volume_number
$	gosub set_issue_number_to_one
$ endif
$ open issue 'ISSUE_FILENAME' /WRITE/ERROR=cannot_open_issue
$ write /ERROR=cannot_write_issue issue issue_number 
$ close issue
$ purge 'ISSUE_FILENAME'
$ return


$increment_volume_number:
$!+++
$! As above, but for volume numbers.
$!---
$ volume_number = volume_number + 1
$ open volume 'VOLUME_FILENAME' /WRITE/ERROR=cannot_open_volume
$ write /ERROR=cannot_write_volume volume volume_number 
$ close volume
$ purge 'VOLUME_FILENAME'
$ return


$set_volume_number_to_one:
$!+++
$! Set the volume number to 1
$!---
$ copy SYS$INPUT: 'VOLUME_FILENAME'
$ DECK
1
$ EOD
$ purge 'VOLUME_FILENAME'
$ volume_number = 1
$ return

$set_issue_number_to_one:
$!+++
$! Set the issue number to 1
$!---
$ copy SYS$INPUT: 'ISSUE_FILENAME'
$ DECK
1
$ EOD
$ purge 'ISSUE_FILENAME'
$ issue_number = 1
$ return


$determine_date_time:
$!+++
$! Determine the date & time in a friendly way and
$! store it in the variable "today"
$!---
$ dt_weekday = f$cvtime(,,"WEEKDAY")
$ dt_mon_n   = f$cvtime(,,"MONTH")
$ dt_month   = f$element(dt_mon_n,"/","/January/February/March/April/May/June"+-
"/July/August/September/October/November/December")
$ dt_day     = f$cvtime(,,"DAY")
$ dt_year    = f$cvtime(,,"YEAR")
$ today      = "''dt_weekday', ''dt_month' ''dt_day', ''dt_year'"
$ return


$ exit
$cannot_open_contents:
$ 	request/to=network "DIGEST-F-CANOOCONTENTS, Cannot open contents for ''listname'"
$	write log "Cannot open contents for ''listname'"
$	close log
$	exit
$cannot_write_contents:
$	request/to=network "DIGEST-F-CNOWRICONTENTS, Cannot write contents for ''listname'"
$	write log "Cannot write contents for ''listname'"
$	close log
$	exit
$cannot_close_contents:
$	request/to=network "DIGEST-F-CNOCLOCONTENTS, Cannot close contents for ''listname'"
$	write log "Cannot close contents for ''listname'"
$	close log
$	exit
$cannot_open_text:
$ 	request/to=network "DIGEST-F-CANOOTEXT, Cannot open text for ''listname'"
$ 	write log "Cannot open text for ''listname'"
$	close log
$	exit
$cannot_write_text:
$	request/to=network "DIGEST-F-CNOWRITEXT, Cannot write text for ''listname'"
$	write log "Cannot write text for ''listname'"
$	close log
$	exit
$cannot_close_text:
$	request/to=network "DIGEST-F-CNOCLOTEXT, Cannot close text for ''listname'"
$	write log "Cannot close text for ''listname'"
$	close log
$	exit
$cannot_open_issue:
$	request/to=network "DIGEST-F-CNOOPENISS, Cannot open issue file for ''listname'"
$	write log "Cannot open issue file for ''listname'"
$	close log
$	exit
$cannot_read_issue:
$	request/to=network "DIGEST-F-CNOREADISS, Cannot read issue for ''listname'"
$	write log "Cannot read issue for ''listname'"
$	close log
$	exit
$cannot_close_issue:
$	request/to=network "DIGEST-F-CNOCLOISS, Cannot close issue for ''listname'"
$	write log "Cannot close issue for ''listname'"
$	close log
$	exit
$cannot_open_volume:
$	request/to=network "DIGEST-F-CNOOPENVOL, Cannot open volume file for ''listname'"
$	write log "Cannot open volume file for ''listname'"
$	close log
$	exit
$cannot_read_volume:
$	request/to=network "DIGEST-F-CNOREADVOL, Cannot read volume for ''listname'"
$	write log "Cannot read volume for ''listname'"
$	close log
$	exit
$cannot_close_volume:
$	request/to=network "DIGEST-F-CNOCLOVOL, Cannot close volume for ''listname'"
$	write log "Cannot close volume for ''listname'"
$	close log
$	exit
