$ !
$ !	QUOTAMAN.COM
$ !
$ !	NEEDS TO RUN UNDER USERNAME OF QUOTAMAN
$ !	MUST HAVE READ ACCESS (USING AN ACL) TO THE DISK'S QUOTA.SYS FILE
$ !
$ begin:
$	version = "V1.0"
$	on error then goto finish
$	on control_y then goto finish
$	proc = f$environment("procedure")
$	procname = f$parse(proc,,,"name","syntax_only")
$	devdir = f$parse(proc,,,"device") + f$parse(proc,,,"directory")
$	say = "write sys$output"
$	say "''procname' ''version'"
$
$ resubmit:
$	procedure = proc - f$parse(proc,,,"version","syntax_only")
$	! MUST RUN AS QUOTAMAN OR EMAIL WILL COME FROM ACCOUNT WHICH RUNS IT !
$	user_qualifier = ""
$	if (f$edit(f$getjpi("","username"),"trim") .nes. "QUOTAMAN")
$	   then user_qualifier = "/user=QUOTAMAN"
$	endif
$	submit 'user_qualifier' /noprinter/queue=sys$batch -
				/log='devdir''procname'.log -
				'procedure'/after="tomorrow+0-01:00" ! 1AM
$	if (f$environment("INTERACTIVE")) then exit
$
$ setup:
$	say "Initializing..."
$	open/read/write/share=write datfile 'devdir'quotaman.dat
$
$ get_quota:
$	say "Loading Quota File..."
$	mcr sysman disk show * /device=mu_users /output='devdir'quotaman.lis
$	open/read quotafile 'devdir'quotaman.lis
$	say "Processing..."
$
$ loop:
$	read/end=finish quotafile record
$	if (f$extract(0,1,record) .nes. "[") then goto loop	! Skip records
$	record = f$edit(record,"compress")
$	permanent = f$element(2," ",record)
$	used = f$element(1," ",record)
$	uic = f$element(0," ",record) - "[" - "]"
$	if f$locate (",",uic) .eqs. f$length(uic)
$	   then username = uic
$	   else username = f$element(1,",",uic)
$	endif
$	datkey = f$fao("!12AS",username)
$	read/error=not_found/key="''datkey'" datfile record
$	found = "true"
$	goto check_percent
$
$ not_found:
$	found = "false"
$
$ check_percent:
$	percent = used/(permanent/100)
$	if (percent .gt. 90)
$	   then if (found)
$		   then say "''username' at ''percent'% already recorded."
$		   else if (percent .lt. 100)
$			   then say "''username' at ''percent'% notified."
$				gosub send_email
$			   else say "''username' at ''percent'% logged."
$			endif
$			write datfile "''datkey'"
$		endif
$	   else if (found)
$		   then say "''username' at ''percent'% back under disk quota."
$			read/key="''datkey'"/delete datfile dummy
$!		   else say "''username' at ''percent'% no need to notify."
$		endif
$	endif
$
$ loop_end:
$	goto loop
$
$ send_email: ! subroutine
$       pmdf mail 'devdir'quotaman.txt 'username' -
	/subject="Disk Quota Notification for user ''username' on HOBBIT"
$	return	! send_email
$
$ finish:
$	if (f$trnlnm("tmpfile") .nes. "")
$	   then close tmpfile
$		delete 'devdir'quotaman.tmp;*
$	endif
$	if (f$trnlnm("quotafile") .nes. "")
$	   then close quotafile
$		delete 'devdir'quotaman.lis;*
$	endif
$	if (f$trnlnm("datfile") .nes. "")
$	   then close datfile
$	endif
$	exit
