$! You should run this script from the same directory of the
$! the source codes.
$!
$ ARCH_NAME = F$GETSYI("ARCH_NAME")
$ prog = "REMOVE_DISPLAY_CHANNEL"
$ PMDF_MASTER_FILE = "REMDISPLAY_CUSTOM_MASTER.COM"
$ say = "write sys$output"
$!
$ if f$search("''prog'.c") .eqs. ""
$  then
$   say ""
$   say "You are not in the right directory."
$   say "You should run this script from the directory where are"
$   say "the files ''prog'.C,PMDFPRINTDEBUG.C,REMOVE_DISPLAY.H."
$   exit
$ endif
$!
$ sel = f$edit(P1,"TRIM,UPCASE")
$ if (sel .nes. "ALL") .AND. (sel .nes. "COMPILE") .AND. -
        (sel .nes. "LINK") .AND. (sel .nes. "SCRIPT") 
$  then
$   say ""
$   say "P1 must be one of the following value:"
$   say "   ALL      compile and link"
$   say "   COMPILE  only compile"
$   say "   LINK     only link"
$   say "   SCRIPT   to create the PMDF master script"
$   exit
$ endif
$!
$ if (sel .eqs. "COMPILE") .OR. (sel .eqs. "ALL")  then CALL compile_prog
$ if (sel .eqs. "LINK") .OR. (sel .eqs. "ALL") 
$  then 
$   CALL link_prog
$   if f$search(PMDF_MASTER_FILE) .eqs. "" 
$    then 
$     CALL pmdf_channel_script
$    else
$     say ""
$     say "The PMDF master script ''PMDF_MASTER_FILE' has not been created"
$     say "because the file already exists in the current directory:"
$     say "   ''f$environment("DEFAULT")"
$     say "If you want to create a new version of this file, call build with P1 = SCRIPT"
$   endif
$ endif
$ if (sel .eqs. "SCRIPT") then CALL pmdf_channel_script
$!
$ exit
$!
$ compile_prog: SUBROUTINE 
$  say ""
$  say "Compiling ''prog'.C ...."
$  cc/object=[.obj]'prog'.obj 'prog'
$  say ""
$  say "Compiling PRINTDEBUG.C ...."
$  cc/object=[.obj]pmdfprintdebug.obj pmdfprintdebug.c
$  exit
$ ENDSUBROUTINE ! compile_prog
$!
$ link_prog: SUBROUTINE
$  say ""
$  say "Linking ''prog'.OBJ ...."
$  link/executable=[.exe]'prog'_'arch_name'.exe; -
     [.obj]'prog',[.obj]pmdfprintdebug.obj,PMDF_EXE:pmdfshr_link.opt/OPT
$  exit
$ ENDSUBROUTINE ! link_prog
$!
$ pmdf_channel_script: SUBROUTINE
$  on warning then goto clean_up
$  say ""
$  say "Creating the pmdf channel master script ...."  
$  executable = f$parse("[.exe]''prog'_''arch_name'.EXE",,,,"SYNTAX_ONLY")
$  if f$search(executable) .eqs. ""
$   then
$    say ""
$    say "ERROR: no executable found (''executable')"
$    say ""
$    exit
$  endif
$  open/write out 'PMDF_MASTER_FILE'
$  write out "$! Run the remdisplay channel program"
$  write out "$ set noon"
$  write out "$ ARCH_NAME = F$GETSYI(""ARCH_NAME"")"
$  write out "$ REMDISPLAY_CHANNEL := $" + executable
$  write out "$ REMDISPLAY_CHANNEL"
$  write out "$ exit"
$  close/nolog out
$  say ""
$  say "You must copy the file ''PMDF_MASTER_FILE' to the PMDF_COM directory."
$  say "Command example:"
$  say "  copy/log  ''PMDF_MASTER_FILE' PMDF_COM:*.*;"
$  exit
$  clean_up:
$   close/nolog out
$   say ""
$   say "ERROR during the creation of the ''PMDF_MASTER_FILE' file"
$   exit
$ ENDSUBROUTINE ! pmdf_channel_script
